using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine().Trim());
        long[] x = new long[n];
        long[] y = new long[n];
        
        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            x[i] = long.Parse(parts[0]);
            y[i] = long.Parse(parts[1]);
        }
        
        long bestDistSq = 0;
        List<int> bestSet = new List<int>();
        
        List<double> angles = new List<double>();
        const double EPS = 1e-9;
        
        for (int j = 0; j < n; j++)
        {
            if (x[j] == 0 && y[j] == 0) continue;
            double theta = Math.Atan2(y[j], x[j]);
            angles.Add(theta + EPS);
            angles.Add(theta + Math.PI + EPS);
        }
        
        angles.Add(0);
        angles.Add(Math.PI / 2);
        angles.Add(Math.PI);
        angles.Add(-Math.PI / 2);
        
        foreach (double theta in angles)
        {
            double cosT = Math.Cos(theta);
            double sinT = Math.Sin(theta);
            
            long sumX = 0, sumY = 0;
            List<int> included = new List<int>();
            
            for (int i = 0; i < n; i++)
            {
                double proj = x[i] * cosT + y[i] * sinT;
                if (proj > EPS) // pozitivna projekcija
                {
                    sumX += x[i];
                    sumY += y[i];
                    included.Add(i + 1); // 1-indeksirano
                }
            }
            
            long distSq = sumX * sumX + sumY * sumY;
            if (distSq > bestDistSq)
            {
                bestDistSq = distSq;
                bestSet = new List<int>(included);
            }
        }

        Console.WriteLine(bestSet.Count);
        if (bestSet.Count > 0)
            Console.WriteLine(string.Join(" ", bestSet));
        else
            Console.WriteLine();
    }
}